//
//  MCPGDaemon.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-02-09.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCClientServer/MCDBDaemon.h>


#define PGDaemon ((MCPGDaemon *)[MCPGDaemon daemon])
#define PGServer PGDaemon.pgServer

#define MC_SERVER_IS_PERSONAL  ([(MCPGServer *)PGServer serverType] == MCPGPersonalServerType)


// Used for creating the URL for keychain items
#define MCSRMakeServerURL(__address__,__db_name__) [[[NSURL alloc] initWithScheme:[PGServer databaseURLScheme]\
host:[NSString stringWithFormat:@"%@:%d", (__address__), [PGServer accessdPort]]\
path:[@"/" stringByAppendingString:(__db_name__)]] autorelease]


@class MCPGServer, MCPDatabaseObjectContext, MCPDatabaseConnection;

@interface MCPGDaemon : MCDBDaemon {

	MCPGServer *pgServer;
}

@property (retain) MCPGServer *pgServer;

// Subclass methods
- (Class)accessClass;
- (NSString *)modelPath;
- (NSString *)logFileName; // used by -logFilePath, which uses the log folder defined by PGServer; defaults to "<ProcessName>.log"

// subclasses must implement
- (Class)serverConnectionClass;

@end
